'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var redditVideoVolumeSliderDocument = document.currentScript.ownerDocument;

var RedditVideoVolumeSlider = function (_HTMLElement) {
  _inherits(RedditVideoVolumeSlider, _HTMLElement);

  function RedditVideoVolumeSlider() {
    _classCallCheck(this, RedditVideoVolumeSlider);

    var _this = _possibleConstructorReturn(this, (RedditVideoVolumeSlider.__proto__ || Object.getPrototypeOf(RedditVideoVolumeSlider)).call(this));

    var shadowRoot = _this.attachShadow({ mode: "open" });
    var template = redditVideoVolumeSliderDocument.querySelector('#reddit-video-volume-slider');
    var clone = document.importNode(template.content, true);
    shadowRoot.appendChild(clone);
    return _this;
  }

  _createClass(RedditVideoVolumeSlider, [{
    key: 'connectedCallback',
    value: function connectedCallback() {
      if (this.hasAttribute('step')) {
        this.step = this.getAttribute('step');
      }

      this.thumb = this.shadowRoot.querySelector('.slider-thumb');
      this.progress = this.shadowRoot.querySelector('.slider-progress');
      this.container = this.shadowRoot.querySelector('.slider-container');
      this.isMouseDown = false;

      if (typeof Storage !== "undefined" && localStorage.redditVideoPlayerVolume) {
        this.value = localStorage.redditVideoPlayerVolume;
      } else {
        this.value = 1;
      }

      var self = this;

      // Set value when slider pressed
      this.container.addEventListener('mousedown', function (event) {
        if (event.which == 1) {
          self.isMouseDown = true;
          var rect = self.container.getBoundingClientRect();
          var offsetY = event.clientY - rect.top;
          var percentage = 100 - offsetY / rect.height * 100;
          self.value = (self.max - self.min) * (percentage / 100);
          var changeEvent = new Event('change');
          self.dispatchEvent(changeEvent);
        }
      });

      // Click and drag volume
      document.addEventListener('mousemove', function (event) {
        if (self.isMouseDown) {
          var rect = self.container.getBoundingClientRect();
          var offsetY = event.clientY - rect.top;
          var percentage = 100 - offsetY / rect.height * 100;
          self.value = (self.max - self.min) * (percentage / 100);
          var changeEvent = new Event('change');
          self.dispatchEvent(changeEvent);
        }
      });

      // Release from click and drag
      document.addEventListener('mouseup', function (event) {
        if (self.isMouseDown) {
          self.isMouseDown = false;
        }
      });

      // Prevent container click behaviour being triggered
      this.addEventListener('click', function (event) {
        event.stopPropagation();
      });
    }
  }, {
    key: 'stepUp',
    value: function stepUp() {
      this.value += this.step;
      var changeEvent = new Event('change');
      this.dispatchEvent(changeEvent);
    }
  }, {
    key: 'stepDown',
    value: function stepDown() {
      this.value -= this.step;
      var changeEvent = new Event('change');
      this.dispatchEvent(changeEvent);
    }
  }, {
    key: 'value',
    set: function set(value) {
      this._value = Math.max(Math.min(value, this.max), this.min);
      var percent = (this._value - this.min) / (this.max - this.min) * 100;
      this.progress.style.height = percent + "%";
    },
    get: function get() {
      return this._value;
    }
  }]);

  return RedditVideoVolumeSlider;
}(HTMLElement);

Object.defineProperties(RedditVideoVolumeSlider.prototype, {
  'min': {
    value: 0,
    writable: false
  },
  'max': {
    value: 1,
    writable: false
  },
  'step': {
    value: 0.1,
    writable: true
  }
});

customElements.define('reddit-video-volume-slider', RedditVideoVolumeSlider);
